var _____WB$wombat$assign$function_____=function(name){return (self._wb_wombat && self._wb_wombat.local_init && self._wb_wombat.local_init(name))||self[name];};if(!self.__WB_pmw){self.__WB_pmw=function(obj){this.__WB_source=obj;return this;}}{
let window = _____WB$wombat$assign$function_____("window");
let self = _____WB$wombat$assign$function_____("self");
let document = _____WB$wombat$assign$function_____("document");
let location = _____WB$wombat$assign$function_____("location");
let top = _____WB$wombat$assign$function_____("top");
let parent = _____WB$wombat$assign$function_____("parent");
let frames = _____WB$wombat$assign$function_____("frames");
let opens = _____WB$wombat$assign$function_____("opens");
( function( $ ) {
	"use strict";
	var ShortcodeVideoNativeHandler, ShortcodeVideoYouTubeHandler, ShortcodeVideoVimeoHandler;
	var ShortcodeVideo = function( html, $container, wrapID ) {
		this.html = html;
		this.wrapID = wrapID;
		this.activeHandler = false;
		this.container = $container;
		this.handlers = {
			youtube: new ShortcodeVideoYouTubeHandler(),
			vimeo: new ShortcodeVideoVimeoHandler(),
			nativeVideo: new ShortcodeVideoNativeHandler()
		};
		return this.init();
	}

	ShortcodeVideo.prototype = {
		init: function() {
			var self = this;
			for ( var id in this.handlers ) {
				var handler = this.handlers[ id ];
				if ( 'test' in handler && handler.test( self.html ) ) {
					self.activeHandler = handler.initialize.call( handler, self.html, self.container, this.wrapID );
					break;
				}
			}
			return this.activeHandler ? this.activeHandler : false;
		}
	};

	function ShortcodeVideoBaseHandler(){ }
	ShortcodeVideoBaseHandler.prototype = {
		deferred: false,
		initialize: function( html, $container, wrapID ) {
			var handler = this;
			this.html = html;
			this.deferred = $.Deferred();
			this.$container = $container;
			this.container 	= this.$container.get( 0 );
			this.wrapID = wrapID;
			this.ready();
			this.events();
			return this.deferred.promise();
		},
		ready: function() {},
		setVideo: function( node ) {
			this.$container.append( $( '<div>', { 'class': 'loftocean-video-wrap', 'id': this.wrapID } ).append( node ) );
		},
		test: function( html ) {
			return false;
		},
		getDimensions: function() {
			var width 	= this.$container.width() || 0, ratio = this.container.ratio || (9 / 16);
			return { 'width': width, 'height': width * ratio };
		},
		resizeVideo: function() {
			var dimension = this.getDimensions(),
				video = this.$container.find( '.loftocean-video-wrap#' + this.wrapID ).children().get( 0 );
			video.width = dimension.width;
			video.height = dimension.height;
		},
		events: function() {
			// var handler = this;
			// $( window ).resize( function( ) {
			// 	handler.resizeVideo();
			// } );
		},
		show: function() {
			this.$container.find( '.loftocean-video-wrap' ).addClass( 'hide' );
			this.$container.addClass('invisible' ).removeClass( 'hide' );
			this.resizeVideo();
			this.$container.find( '#' + this.wrapID ).removeClass( 'hide' );
			this.$container.removeClass( 'invisible' );
			$( 'body' ).css( 'overflow', 'hidden' );
			$( '.loftocean-media-wrapper.loftocean-media-fullscreen-playing .close-button' ).data( 'player', this );
			this.playVideo();
		},
		playVideo: function() {},
		pauseVideo: function() {}
	};

	ShortcodeVideoBaseHandler.extend = function( protoProps ) {
		var prop;
		function CustomHandler() {
			var result = ShortcodeVideoBaseHandler.apply( this, arguments );
			return result;
		}

		CustomHandler.prototype = Object.create( ShortcodeVideoBaseHandler.prototype );
		CustomHandler.prototype.constructor = CustomHandler;
		for ( prop in protoProps ) {
			CustomHandler.prototype[ prop ] = protoProps[prop];
		}
		return CustomHandler;
	};

	ShortcodeVideoNativeHandler = ShortcodeVideoBaseHandler.extend( {
		test: function( html ) {
			var video = document.createElement( 'video' ), regex = /\/\/.+\/.+\.(mp4|webm|ogg|mov)/;
			if ( regex.exec( html ) ) {
				video.src = html.match( regex )[0];
				this.video = video;
				return true;
			}
			return false;
		},
		ready: function() {
			var handler = this, video = $( this.video ).get(0);

			video.autoplay = false;
			video.loop = 'loop';
			video.controls = 'controls';

			this.video = video;
			handler.setVideo( video );
			$( handler.video ).on( 'loadedmetadata', function() {
				handler.container.ratio = ( this.videoHeight || 9 ) / ( this.videoWidth || 16 );
				handler.deferred.resolve( handler );
			} );
			$( window ).on( 'resize', function() {
				if ( handler.container.ratio ) {
					handler.resizeVideo.call( handler );
				}
			} );
		},
		playVideo: function() {
			this.video.play();
		},
		pauseVideo: function() {
			this.video.pause();
		}
	} );

	ShortcodeVideoYouTubeHandler = ShortcodeVideoBaseHandler.extend( {
		regex: /^.*(?:(?:youtu\.be\/|v\/|vi\/|u\/\w\/|embed\/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?'"]*).*/,
		test: function( html ) {
			return this.regex.exec( html );
		},
		ready: function() {
			var handler = this;

			if ( 'YT' in window ) {
				YT.ready( handler.loadVideo.bind( handler ) );
			} else {
				var tag = document.createElement( 'script' );
				tag.src = 'https://www.youtube.com/iframe_api';
				tag.onload 	= function() {
					YT.ready( handler.loadVideo.bind( handler ) );
				};
				document.getElementsByTagName( 'head' )[0].appendChild( tag );
			}
		},
		loadVideo: function() {
			var handler = this,
				video = $( '<div>', { 'class': 'youtube-video' } ).get( 0 ),
				vid = this.html.match( this.regex )[1];

			$.getJSON( 'https://noembed.com/embed', { format: 'json', url: ( 'https://www.youtube.com/watch?v=' + vid ) }, function( data ) {
				var dimensions;
				handler.container.ratio = ( data.height || 9 ) / ( data.width || 16 );
				dimensions = handler.getDimensions.call( handler );

				handler.setVideo( video );
				handler.player = new YT.Player( video, {
					videoId: vid,
					width: dimensions.width,
					height: dimensions.height,
					events: {
						onReady: function( e ) {
//							e.target.mute();
							handler.video = handler.$container.find( '.youtube-video' ).get( 0 );
							handler.deferred.resolve( handler );
						},
						onStateChange: function( e ) {
							if ( YT.PlayerState.ENDED === e.data ) {
								e.target.playVideo();
							}
						}
					},
					playerVars: {
						autoplay: 		0,
						controls: 		1,
						disablekb: 		1,
						fs: 			0,
						iv_load_policy: 3,
						loop: 			1,
						modestbranding: 1,
						playsinline: 	1,
						rel: 			0,
						showinfo: 		0
					}
				} );
				$( window ).on( 'resize', function() {
					if ( handler.container.ratio && handler.video ) {
						handler.resizeVideo.call( handler );
					}
				} );
			} );
		},
		playVideo: function() {
			this.player.playVideo();
		},
		pauseVideo: function() {
			this.player.pauseVideo();
		}
	} );

	ShortcodeVideoVimeoHandler = ShortcodeVideoBaseHandler.extend( {
		regex: /https?:\/\/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\d+)\/video\/|video\/|)(\d+)/,
	 	test: function( html ) {
			return this.regex.exec( html );
		},
		ready: function() {
			this.loadVideo();
		},
		loadVideo: function() {
			var handler = this,
				vid = this.html.match( this.regex )[3],
				video = $( '<div>', { 'id': 'vimeo-video-' + vid } ).get( 0 );

			if ( Vimeo && Vimeo.Player ) {
				var options = { 'id': vid, 'loop': true };
				handler.setVideo( video );
				handler.player = new Vimeo.Player( 'vimeo-video-' + vid, options );
				Promise.all( [ handler.player.getVideoWidth(), handler.player.getVideoHeight() ] ).then( function( dimensions ) {
					handler.container.ratio = dimensions[1] / dimensions[0];
					handler.video = handler.$container.find( 'iframe' ).get( 0 );
					handler.deferred.resolve( handler );
					$( window ).on( 'resize', function() {
						if ( handler.container.ratio ) {
							handler.resizeVideo.call( handler );
						}
					} );
				} );
			}
		},
		playVideo: function() {
			this.player.play();
		},
		pauseVideo: function() {
			this.player.pause();
		}
	} );

	function string2Hash( str, seed = 0 ) {
	    var h1 = 0xdeadbeef ^ seed, h2 = 0x41c6ce57 ^ seed;
	    for ( var i = 0, ch; i < str.length; i++ ) {
	        ch = str.charCodeAt(i);
	        h1 = Math.imul(h1 ^ ch, 2654435761);
	        h2 = Math.imul(h2 ^ ch, 1597334677);
	    }
	    h1 = Math.imul(h1 ^ (h1>>>16), 2246822507) ^ Math.imul(h2 ^ (h2>>>13), 3266489909);
	    h2 = Math.imul(h2 ^ (h2>>>16), 2246822507) ^ Math.imul(h1 ^ (h1>>>13), 3266489909);
	    return 4294967296 * (2097151 & h2) + (h1>>>0);
	}

	$( document ).ready( function() {
		$( 'body' ).on( 'click', '.loftocean-media-wrapper.loftocean-media-fullscreen-playing .close-button', function ( e ) {
			e.preventDefault();
			var $close = $( this );
			if ( $close.data( 'player' ) ) {
				$close.data( 'player' ).pauseVideo();
				$close.data( 'player', false );
			}
			$( '.loftocean-media-wrapper.loftocean-media-fullscreen-playing' ).addClass( 'hide' );
			$('body').css( 'overflow', '' );
		} ).on( 'video.play', function( e, el, video ) {
			if ( ( typeof el != 'undefined' ) && $( el ).length && ( typeof video != 'undefined' ) ) {
				var $btn = $( el ), clearData = true, videoID = string2Hash( video );
				// Return if still process previous clicking
				if ( $btn.data( 'clicking' ) ) {
					return false;
				}
				$btn.data( 'clicking', true );
				if ( $btn.data( 'player' ) ) {
					$btn.data( 'player' ).show();
					$btn.data( 'clicking', false );
				} else {
					var $wrap = $( '.loftocean-media-wrapper.loftocean-media-fullscreen-playing' );
					if ( ! $wrap.length ) {
						$wrap = $( '<div>', { 'class': 'loftocean-media-wrapper loftocean-media-fullscreen-playing invisible' } ).append(
							$( '<div>', { 'class': 'close-button', 'text': 'close' } )
						);
						$( 'body' ).append( $wrap );
					}
					var deferred = new ShortcodeVideo( video, $wrap, videoID );
					if ( deferred ) {
						clearData = false;
						deferred.done( function( handler ) {
							$btn.data( 'player', handler );
							handler.show();
						} ).always( function() {
							$btn.data( 'clicking', false );
						} );
					}
					if ( clearData ) {
						$btn.data( 'clicking', false );
					}
				}
			}
		} );
		if ( loftoceanShortcodeVideos && Array.isArray( loftoceanShortcodeVideos ) ) {
			$( '.video-block.theme-shortcode-video .video-play-btn' ).on( 'click', function( e ) {
				var $btn = $( this ), clearData = true, videoID = 'loftocean-fullscreen-'  + $btn.data( 'shortcode-video-id' );
				// Return if still process previous clicking
				if ( $btn.data( 'clicking' ) ) {
					return false;
 				}
 				$btn.data( 'clicking', true );
				if ( $btn.data( 'player' ) ) {
					$btn.data( 'player' ).show();
					$btn.data( 'clicking', false );
				} else {
					if ( $btn.data( 'shortcode-video-id' ) ) {
						var vid = $btn.data( 'shortcode-video-id' ).replace( 'video-id-', '' );
						if ( loftoceanShortcodeVideos[ vid ] ) {
							var $wrap = $( '.loftocean-media-wrapper.loftocean-media-fullscreen-playing' );
							if ( ! $wrap.length ) {
								$wrap = $( '<div>', { 'class': 'loftocean-media-wrapper loftocean-media-fullscreen-playing invisible' } ).append(
									$( '<div>', { 'class': 'close-button', 'text': 'close' } )
								);
								$( 'body' ).append( $wrap );
							}
							var deferred = new ShortcodeVideo( loftoceanShortcodeVideos[ vid ], $wrap, videoID );
							if ( deferred ) {
								clearData = false;
								deferred.done( function( handler ) {
									$btn.data( 'player', handler );
									handler.show();
								} ).always( function() {
									$btn.data( 'clicking', false );
								} );
							}
						}
					}
					if ( clearData ) {
						$btn.data( 'clicking', false );
					}
				}
			} );
		}
	} );
} )( jQuery );

}